<?php

if(isset($_POST)) {
	
	$errors = array();
	$return = array(
		'status' => false,
		'message' => false
	);
	
	$fields = array(
		'enquiry_name' => 'Name',
		'enquiry_email' => 'Email',
		'enquiry_contact' => 'Contact Number',
		'enquiry_type' => 'Enquiry Type',
		'enquiry_region' => 'Region',
		'enquiry_text' => 'Enquiry',
	);
	
	$to_email = 'corporate@gitn.com.my';
	$email_form = '';
	$enquiry_name = '';
	
	foreach($fields as $field_name => $field_label) {
		if ($_POST[$field_name] != "") {
			$_POST[$field_name] = filter_var($_POST[$field_name], FILTER_SANITIZE_STRING);
			if ($_POST[$field_name] == "") {
				$errors[] = 'Please enter a valid '.$field_label;
			} else {
				// if($field_name == 'enquiry_email') {
				// 	$to_email = $_POST[$field_name];
				// }
				if($field_name == 'enquiry_name') {
					$enquiry_name = $_POST[$field_name];
				}
				$email_form .= '<tr>';
				$email_form .= '<th style="background-color:#f1f1f1;">'.$field_label.'</th>';
				$email_form .= '<td>'.$_POST[$field_name].'</td>';
				$email_form .= '</tr>';
			}
		} else {
			$errors[] = 'Please enter '.$field_label;
		}
	}
	
	if($errors) {
		$return['status'] = false;
		$return['message'] = '<ul><li>'.join('</li><li>', $errors).'</li></ul>';
	} else {
		
		$subject = "GITN Website: New Enquiry from ".$enquiry_name;
		$message = "";
		$message .= '<table border="1" cellspacing="0" cellpadding="5">';
		$message .= $email_form;
		$message .= '</table>';
		
		$sender = 'noreply@gitn.net.my';
		
		$headers = "From: ".$sender;
		mail($to_email, $subject, $message, $headers);
		$return['status'] = true;
	}
	
	echo json_encode($return);
}

die();