var openmap;
var all_markers = [];
var map_center = [4.2, 109];
var control_bounds = [[6.659499, 99.415157], [7.565940, 108.395208], [0.858409, 110.575370], [5.317121, 119.243757]];
var resize_delay;

$(document).ready(function() {
	// Ready
	$(document).on('click', '.menu .language .current', function() {
		$(this).siblings('ul').toggleClass('show');
	});

	$(document).on('click', '.overlay .close', function() {
		$('.overlay').removeClass('show');
		$('.profile-popup .row').removeClass('show');
	});

	$(document).on('click', '.profile .action a, .page-header .action a', function() {
		let who = $(this).data('who');
		if ($('.profile-popup .row[rel=' + who + ']').length) {
			$('.overlay').addClass('show');
			$('.profile-popup .row[rel=' + who + ']').addClass('show');
		}
	});

	$('.home-slider.carousel').slick({
		dots: true,
		arrows: false,
		infinite: true,
		autoplay: true,
		speed: 1000,
		slidesToShow: 1,
	});

	$('.gallery-slider.carousel').slick({
		dots: true,
		arrows: false,
		infinite: false,
		autoplay: false,
		speed: 1000,
		slidesToShow: 1,
		centerMode: true,
	});
	
	if (location.hash) {
		let hash = location.hash;
		let goto = hash.substring(1);
		if($('[data-anchor='+goto+']').length) {
			setTimeout(function() {
				$([document.documentElement, document.body]).animate({
					scrollTop: $('[data-anchor='+goto+']').offset().top - $('.top-menu').height()
				}, 1000);
			}, 400);
		}
	}


	if ($('.map-area').length) {
		openmap = L.map('map-area', {
			center: map_center,
			zoomSnap: 0.1,
			zoom: 6.5,
		});
		L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
			maxZoom: 7,
			minZoom: 5,
			attribution: '&copy; <a href="https://openstreetmap.org/copyright">OpenStreetMap contributors</a>'
		}).addTo(openmap);

		L.control.scale({ imperial: true, metric: true }).addTo(openmap);

		var features = [];

		let outlet_latlong = [];
		$('.support-branch-list .branch:not(.blank)').each(function() {
			let branch = $(this);
			let branch_obj = {
				outlet_id: branch.find('.branch-num').html(),
				num: branch.find('.branch-num').html(),
				name: branch.find('.branch-title').html(),
				address: branch.find('.branch-address').html(),
				phone: branch.find('.branch-contact').html(),
				long: branch.data('long'),
				lat: branch.data('lat'),
			};
			outlet_latlong[branch_obj.outlet_id] = branch_obj;
		});

		for (i in outlet_latlong) {
			var the_branch = outlet_latlong[i];
			var html_text = '<div class="marker-content">';
			html_text += '<div class="popup-mapinfo"><div class="name">' + the_branch.name + '</div><div class="address">' + the_branch.address + '</div><div class="phone">' + the_branch.phone + '</div></div></div>';

			var new_item = {
				"type": "Feature",
				"properties": {
					"popupContent": html_text,
					"num": the_branch.num,
					"outlet_id": the_branch.outlet_id
				},
				"geometry": {
					"type": "Point",
					"coordinates": [the_branch.long, the_branch.lat]
				}
			}
			features.push(new_item);
		}

		var branches_poi = {
			"type": "FeatureCollection",
			"features": features
		};

		var branches_layer = L.geoJSON(branches_poi, {
			pointToLayer: function(feature, latlng) {
				let le_marker = L.circleMarker(latlng, {
					radius: 14,
					fillColor: '#1800E7',
					color: '#FFFFFF',
					weight: 1,
					opacity: 1,
					fillOpacity: 1
				});
				all_markers.push(le_marker);
				return le_marker;
			},
			onEachFeature: function(feature, layer) {
				let le_marker = feature;
				layer.on('click', function() {
					if (openmap.getZoom() >= 12) {
						openmap.panTo(this.getLatLng());
					} else {
						openmap.setView(this.getLatLng(), 7);
					}

					let le_marker2 = le_marker;
					setTimeout(function() {
						layer.bindPopup(le_marker2.properties.popupContent).openPopup();
					}, 400);

				});

				var num = feature.properties.num.toString();
				var text = L.tooltip({
						permanent: true,
						direction: 'center',
						className: 'text'
					})
					.setContent(num)
					.setLatLng(layer.getLatLng());
				text.addTo(openmap);
			}
		}).addTo(openmap);
		
		// polyline = L.polyline(control_bounds, {color: 'red'}).addTo(openmap);
		openmap.fitBounds(control_bounds);
		dynamicMapZoom();
	}
	
	// openstreetmap
	$('.branch .branch-title').on('click', function(e){
		let branch = $(this).closest('.branch');
		let branch_obj = {
			outlet_id: branch.find('.branch-num').html(),
			num: branch.find('.branch-num').html(),
			name: branch.find('.branch-title').html(),
			address: branch.find('.branch-address').html(),
			phone: branch.find('.branch-contact').html(),
			long: branch.data('long'),
			lat: branch.data('lat'),
		};
		
		$([document.documentElement, document.body]).animate({
			scrollTop: $("#map-area").offset().top - $('.top-menu').height()
		}, 1000);
		if(typeof openmap !== 'undefined') {
			if(typeof all_markers !== 'undefined') {
				let found_marker = false;
				for(i in all_markers) {
					let le_marker = all_markers[i];
					let le_outlet_id = le_marker.feature.properties.outlet_id;
					if(le_outlet_id == branch_obj.outlet_id) {
						found_marker = le_marker;
					}
				}
				if(found_marker) {
					found_marker.fire('click');
					openmap.setView(found_marker.getLatLng(), 16);
				}
			}
		}
	});
	
	$('.btn-submit').on('click', function(e){
		$(this).closest('form').trigger('submit');
	});
	
	let le_form = $('form[name=enquiry_form]');
	if(le_form.length) {
		$(le_form).validate({
			submitHandler: function(form) {
				$.ajax({
					type: 'POST',
					url: 'mail.php',
					cache: false,
					data: $(le_form).serialize(),
					beforeSend: function() {
						$(le_form).find('.btn-submit').prop('disabled', true);
						$(le_form).find('.form-status').append('<div class="please-wait-submit">Submitting your form. Please wait...</div>');
					},
					success: function (response) {
						let result = $.parseJSON(response);
						if(result.status) {
							$(le_form)[0].reset();
							$(le_form).find('.form-status').removeClass('error');
							$(le_form).find('.form-status').addClass('success');
							$(le_form).find('.form-status').html('Thank you for your enquiry.');
						} else {
							$(le_form).find('.form-status').removeClass('success');
							$(le_form).find('.form-status').addClass('error');
							$(le_form).find('.form-status').html(result.message);
						}
					},
					complete: function() {
						$(le_form).find('.btn-submit').prop('disabled', false);
						$(le_form).find('.please-wait-submit').remove();
					}
				});
			}
		});	
	}
	
	$( window ).on( "resize", function() {
		if ($('.map-area').length) {
			trigger_map_resize();
		}
	} );
	
	function trigger_map_resize(){
		if(resize_delay) {
			clearTimeout(resize_delay);	
		}
		resize_delay = setTimeout(function() {
			dynamicMapZoom();
		}, 600);
	}
	
	function dynamicMapZoom() {
		openmap.fitBounds(control_bounds);
	}
});
